---
title: Lecture 56：幂级数
tags:
  - 数学
  - 无穷级数
categories: 
date: 2024-02-14
---
  **本节内容概要**
+ （一）收敛半径、收敛区间、收敛域
+ （二）幂级数的性质
+ （三）函数的幂级数展开

**本节常考题型**
+ 题型一：求收敛半径、收敛区间及收敛域
+ 题型二：将函数展开为幂级数
+ 题型三：级数求和
	+ 难点
	+ 重点

---
## 50.1 幂级数
### 50.1.1 基本概念
**数列**：每一项只和 n 有关
+ 数列： $u_{1},u_{2},\cdots,u_{n}$
+ 无穷级数：$u_{1}+u_{2}+\cdots+u_{n}+\cdots$

**函数列**：每一项和 n 以及 $x$ 有关
+ 假设 x 在区间 $I$ 上；
+ 函数列： $u_{1}(x), u_{2}(x), u_{n}(x),\cdots$
+ 函数项无穷级数：$u_{1}(x)+u_{2}(x)+\cdots+u_{n}(x)+\cdots$ 

##### **定义**： #幂级数
> <font color="#ccc1d9">描述：</font> 
> 常见形式： $$\sum_{n=0}^\infty a_nx^n=a_0+a_1x+a_2x^2+\cdots+a_nx^n+\cdots $$
> 一般形式：$$\sum_{n=0}^\infty a_n(x-x_0)^n=a_0+a_1(x-x_0)+\cdots+a_n(x-x_0)^n+\cdots $$

**解释**
+ 概念：
	+ 每一项都是 x 的正整数幂：幂级数： $a_{0}a_{1},a_{2}x^{2}\cdots a_{n}x^{n}\cdots$
	+ 幂级数其实是函数项级数的最简单的一种，$x^{n}$ 就是 x 的函数，$a_n$ 就是一列数；
	+ $a_0,a_1,a_2...a_n$ 称之为系数；
+ 补充：
	+ 一般研究常见形式，因为一般形式可以用 $x-x_0=t$ 化成常见形式；


### 50.1.2 收敛与发散
##### **定义**： #收敛点与发散点
> <font color="#ccc1d9">描述：</font>
> 1. 如果 $x_{0}\in I$ 时，$u_{1}(x)+u_{2}(x)+\cdots+u_{n}(x)+\cdots$ 收敛，则称 $x_o$ 为收敛点，如果是一段区间则称之为收敛域；
> 2. 如果 $x_{0}\in I$ 时，$u_{1}(x)+u_{2}(x)+\cdots+u_{n}(x)+\cdots$ 发散，则称 $x_o$ 为发散点，如果是一段区间则称之为发散域；
> 3. $S\left (x\right)=u\left (x\right)+u_{2\left (x\right)}+\cdots+u_{n}\left (x\right)+\cdots$ 称之为和函数，$\lim_{n\to\infty}S_n(x)=S\left(x\right)$；

**解释**
+ 一般就是求两个问题：收敛域是什么？和函数是什么？

**举例**
+ $1+x+x^{2}+x^{3}+\cdots+x^{n}+\cdots$
+ 此时：
	+ $|x|<1\text{时，收敛城(-1,1)}\frac{a}{1-q}=\frac{1}{1-x}$
	+ $|\times|\geq1 时，发散域(-\infty,-1)|U[1,+\infty]$

##### **定理**： #阿贝尔定理 
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 
> $$\sum_{n=0}^{+\infty}a_nx ，当x=x_0 时收敛,|x|<|x_0|时幂级数绝对收敛$$
> $$\sum_{n=0}^{+\infty}a_nx ，当x=x_0 时发散,|x|>|x_0|时幂级数发散$$

**解释**
+ 定理的作用：
	+ 揭示了当前幂级数的收敛、发散的域的结构 `->` 将求收敛域的问题、转化成了求整个区间一般长度的问题 `->` 也就是求收敛半径 `R` ；
+ 绝对收敛：
	+ 在 $|x|<|x_0|$ 时，此时在这个区间内的点，也都收敛 `->` 离原点更近的点收敛；
+ 发散：
	+ 在 $|x|>|x_0|$ 时，此时在这个区间外的点，也都收敛 `->` 离原点更远的点发散；
+ 总结：
	+ 1. 收敛点和发散点的分界点 `->` 就是**收敛半径 R**
	+ 2. 两个级数 $\sum_{n=0}^{+\infty}a_n{(x+2)}$ 和 $\sum_{n=0}^{+\infty}a_n{(x-3)}$ ，如果它们的 $a_n$ 一样，则它们有共同的收敛半径 `R`； 
+ 注意： 
	+ 收敛区间不需要关注端点；
	+ 收敛域需要关注端点；

**补充**：收敛区间和收敛域
+ 收敛区间：
	+ $(-R,+R)$
+ 收敛域：
	+ 包括端点在内：$\pm R$
	+ 分别判断两个端点的值后，得到的区间；

**补充**：关于 $x$ 不等于 $x_0$ 时的收敛域
+ 前提：
	+ 根据 `<总结-1>` 可知，$\sum_{n=0}^{+\infty}a_n{(x+2)}$ 和 $\sum_{n=0}^{+\infty}a_n{(x-3)}$ 的收敛半径 R 一样；
+ 概念：
	+ 收敛区间： 
		+ 对 $\sum_{n=0}^{+\infty}a_n{(x+2)}$ 而言，其中心在 `x=-2` 点，因此假设其收敛点在 `x=0` 处时，其收敛半径为 `0-(-2)=2` ，因此其收敛区间就是：
		+ $$收敛区间：(x_0-R,x_0+R)\rightarrow (-2-2,-2+2)\rightarrow (-4,0)$$
	+ 端点收敛性不变性：
		+ 因为两个级数的 $a_n$ 项相同，所以这两个级数的收敛域的两个端点同敛散性；

##### **定理**： #幂级数的收敛情况
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> 幂级数  $\sum_{n=0}^{+\infty}a_nx$ 的收敛性有且仅有三种可能：
> （1）对任何 x 属于 $(-\infty ,+\infty)$ 都收敛；
> （2）只在 $x=0$ 处收敛；
> （3）存在一个正数 `R` 当 $|x| < R$ 时绝对收敛，当 $|x|>R$ 时发散； 
> 注意：若幂级数 $\sum_{n=0}^{+\infty}a_nx$ 在点 $x=x_0$ 处条件收敛，则点 $x_0$ 必为该幂级数收敛区间 $(-R,R)$ 的一个端点；

### 50.1.3 收敛半径 R
##### **定理**： #收敛半径判断
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$若\lim_{n\to\infty}\left|\frac{a_{n+1}}{a_{n}}\right|=\rho，则 R = \frac{1}{{\rho}}$$
> 即：此时有三种情况：$$R=\begin{cases}\frac{1}{\rho},&\rho\neq0\\+\infty,&\rho=0\\0,&\rho=+\infty\end{cases}$$

**解释**
+ 注意： 
+ 1. 此定理只能单方向使用；
+ 2. 收敛区间是不管端点的，即 $(-R,R)$


##### **定理**： #收敛半径判断：基于根式
> <font color="#8db3e2"><font color="#c6d9f0">描述：</font></font> $$\text{如果 }\lim_{n\to\infty}\sqrt[n]{|a_n|}=\rho,\text{则}\quad R=\frac1\rho $$

**解释**
+ 基于根值法推导而来；

## 50.2 幂级数的运算
### 50.2.1 幂级数的运算性质
**性质**：有理运算性质
+ 前提：
	+ 设
	+ 1.  $\sum_n^{\infty}a_nx^n$ 的收敛半径为 $R_1$
	+ 2.  $\sum_n^{\infty}b_nx^n$ 的收敛半径为 $R_2$
	+ 令 $R=\min\{R_1,R_2\}$，则当 $x\in(-R,R)$ 时：
+ 运算性质：
	+ （1）加法：$$\sum_{n=0}^\infty a_nx^n\pm\sum_{n=0}^\infty b_nx^n=\sum_{n=0}^\infty(a_n\pm b_n)x^n$$
	+ （2）乘法：$$(\sum_{n=0}^\infty a_nx^n)\cdot(\sum_{n=0}^\infty b_nx^n)=\sum_{n=0}^\infty c_nx^n$$ 
		+ 且：$c_n=a_0b_n+a_1b_{n-1}+\cdots+a_nb_0$ 
	+ （3）除法：$$\frac{\sum_{n=0}^\infty a_nx^n}{\sum_{n=0}^\infty b_nx^n}=\sum_{n=0}^\infty c_nx^n$$
 
### 50.2.2 幂级数的分析性质
**性质**：逐项求导
+ 前提：
	+ 若 $\sum_{n=0}^{+\infty}a_{n}x^{n}$ 的收敛半径是 `R`，和函数为 $S(x)$，则：
+ 分析性质：
	+ （1）连续性：
		+ $S(x)$ 在它的收敛域上 $I$ 是连续的；
	+ （2）可导性：
		+ $S(x)$ 在 $(-R,R)$ 上可导，且可以逐项求导，半径不变，即：
			+ $$S^{\prime}(x)=\left(\sum_{n=0}^\infty a_nx^n\right)^{\prime}=\sum_{n=0}^\infty(a_nx^n)^{\prime}=\sum_{n=0}^\infty na_nx^{n-1}$$
		+ 注意：这里面级数求导之后，收敛半径没有变化，还是 R，并且通项当中还多了一个 $n$
	+ （3）可积性：
		+ 若 $\sum_{n=0}^{\pm\infty}a_{n}x^{n}$ 的和函数 $S(x)$ 在 $I$ 上是可积的，且可以逐项积分，则：
			+ $$\int_{0}^{x}S(x)\operatorname{d}x=\int_{0}^{x}\sum_{n=0}^{\infty}a_{n}x^{n}\operatorname{d}x=\sum_{n=0}^{\infty}\int_{0}^{x}a_{n}x^{n}\operatorname{d}x=\sum_{n=0}^{\infty}\frac{1}{n+1}a_{n}x^{n+1}$$
		+ 注意：逐项求积分后的幂级数，与原幂级数的收敛半径是相同的；


## 50.3 常考题型
---
### 题型： #求收敛半径、收敛区间、收敛域 
#### PART 1：解题方法
**题型**：求收敛半径
+ 两种方法：
	+ 方法一：使用收敛半径判定法
	+ 方法二：使用收敛半径根值判定法
+ 注意：缺项时
	+ 缺项：$x^{2n-1}$ ，不是 $x^n$
	+ 缺项时不能直接使用公式，如果是 $x^{2n+b}$ ，则此时都需要将根值法算得的 `R` 开一个 $\frac{1}{2}$ 次方；

**题型**：求收敛区间
+ 方法：
	+ 想要求得收敛区间，需要先求得收敛半径；

**题型**：求端点的收敛性
+ 方法：
	+ 分别将端点的 $x=\pm x_0$ 代入进去，得到关于 n 的函数式，即：当前级数的通项。此时解题方法和常数项级数一致，根据其是正项、交错级数、任意项级数，选择方法，判定；
 
**题型**：判断任意一点的收敛性
+ 方法：
	+ 先求出当前幂级数的收敛半径（经常要使用阿贝尔定理），然后根据收敛区间，判断任意一点是否在区间内，即可得到收敛性；

#### PART 2：典型例题
**例题**：求 $\sum_{n=1}^\infty\frac{e^n-(-1)^n}{n^2}x^n$ 

#### PART 3：知识点复盘
**知识点**：当幂级数 $\sum_{n=0}^\infty na_nx^n$ 的 $a_n$ 旁边有 n 时
+ 知识点：根据幂级数的**逐项求导后、收敛半径不变**的性质，可知 $\sum_{n=0}^\infty na_nx^n$ 和 $\sum_{n=0}^\infty a_nx^n$ 的 R 不变；
